/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class SpringTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement ae) {
        Transactional ann = ae.getAnnotation(Transactional.class);
        if (ann == null) {
            Annotation[] annotationArray = ae.getAnnotations();
            int n2 = annotationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Annotation metaAnn = annotationArray[n3];
                ann = metaAnn.annotationType().getAnnotation(Transactional.class);
                if (ann != null) break;
                ++n3;
            }
        }
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(Transactional ann) {
        String[] nrbfc;
        Class<? extends Throwable>[] nrbf;
        String[] rbfc;
        Class<? extends Throwable>[] rbf;
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        rbta.setPropagationBehavior(ann.propagation().value());
        rbta.setIsolationLevel(ann.isolation().value());
        rbta.setTimeout(ann.timeout());
        rbta.setReadOnly(ann.readOnly());
        rbta.setQualifier(ann.value());
        ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
        Class<? extends Throwable>[] classArray = rbf = ann.rollbackFor();
        int n2 = rbf.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<? extends Throwable> rbRule = classArray[n3];
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n3;
        }
        String[] stringArray = rbfc = ann.rollbackForClassName();
        int n4 = rbfc.length;
        n2 = 0;
        while (n2 < n4) {
            String rbRule = stringArray[n2];
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n2;
        }
        Class<? extends Throwable>[] classArray2 = nrbf = ann.noRollbackFor();
        int n5 = nrbf.length;
        n4 = 0;
        while (n4 < n5) {
            Class<? extends Throwable> rbRule = classArray2[n4];
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n4;
        }
        String[] stringArray2 = nrbfc = ann.noRollbackForClassName();
        int n6 = nrbfc.length;
        n5 = 0;
        while (n5 < n6) {
            String rbRule = stringArray2[n5];
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n5;
        }
        rbta.getRollbackRules().addAll(rollBackRules);
        return rbta;
    }
}

