/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.ClassUtils;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    private static final boolean loadFromReaderAvailable = ClassUtils.hasMethod(Properties.class, "load", Reader.class);
    private static final boolean storeToWriterAvailable = ClassUtils.hasMethod(Properties.class, "store", Writer.class, String.class);

    public void load(Properties props, InputStream is) throws IOException {
        props.load(is);
    }

    public void load(Properties props, Reader reader) throws IOException {
        if (loadFromReaderAvailable) {
            props.load(reader);
        } else {
            this.doLoad(props, reader);
        }
    }

    protected void doLoad(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = String.valueOf(line) + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value = StringUtils.trimLeadingWhitespace(value);
            props.put(this.unescape(key), this.unescape(value));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index) == '\\') {
            evenSlashCount = !evenSlashCount;
            --index;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuilder result = new StringBuilder(str.length());
        int index = 0;
        while (index < str.length()) {
            int c2;
            if ((c2 = str.charAt(index++)) == 92) {
                if ((c2 = str.charAt(index++)) == 116) {
                    c2 = 9;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 102) {
                    c2 = 12;
                }
            }
            result.append((char)c2);
        }
        return result.toString();
    }

    public void store(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
    }

    public void store(Properties props, Writer writer, String header) throws IOException {
        if (storeToWriterAvailable) {
            props.store(writer, header);
        } else {
            this.doStore(props, writer, header);
        }
    }

    protected void doStore(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(String.valueOf(this.escape(key, true)) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuilder result = new StringBuilder(len * 2);
        int index = 0;
        while (index < len) {
            char c2 = str.charAt(index);
            switch (c2) {
                case ' ': {
                    if (index == 0 || isKey) {
                        result.append('\\');
                    }
                    result.append(' ');
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c2) != -1) {
                        result.append('\\');
                    }
                    result.append(c2);
                }
            }
            ++index;
        }
        return result.toString();
    }

    public void loadFromXml(Properties props, InputStream is) throws IOException {
        try {
            props.loadFromXML(is);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header) throws IOException {
        try {
            props.storeToXML(os, header);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header, String encoding) throws IOException {
        try {
            props.storeToXML(os, header, encoding);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }
}

