/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String[] authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        if (this.authorizedRoles != null) {
            String[] stringArray = this.authorizedRoles;
            int n2 = this.authorizedRoles.length;
            int n3 = 0;
            while (n3 < n2) {
                String role = stringArray[n3];
                if (request.isUserInRole(role)) {
                    return true;
                }
                ++n3;
            }
        }
        this.handleNotAuthorized(request, response, handler);
        return false;
    }

    protected void handleNotAuthorized(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        response.sendError(403);
    }
}

