/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.WebUtils;

abstract class ServletAnnotationMappingUtils {
    ServletAnnotationMappingUtils() {
    }

    public static boolean checkRequestMethod(RequestMethod[] methods, HttpServletRequest request) {
        if (ObjectUtils.isEmpty((Object[])methods)) {
            return true;
        }
        RequestMethod[] requestMethodArray = methods;
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            RequestMethod method = requestMethodArray[n3];
            if (method.name().equals(request.getMethod())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean checkParameters(String[] params, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty(params)) {
            String[] stringArray = params;
            int n2 = params.length;
            int n3 = 0;
            while (n3 < n2) {
                String param = stringArray[n3];
                int separator = param.indexOf(61);
                if (separator == -1) {
                    if (param.startsWith("!") ? WebUtils.hasSubmitParameter(request, param.substring(1)) : !WebUtils.hasSubmitParameter(request, param)) {
                        return false;
                    }
                } else {
                    boolean negated = separator > 0 && param.charAt(separator - 1) == '!';
                    String key = !negated ? param.substring(0, separator) : param.substring(0, separator - 1);
                    String value = param.substring(separator + 1);
                    if (!value.equals(request.getParameter(key))) {
                        return negated;
                    }
                }
                ++n3;
            }
        }
        return true;
    }

    public static boolean checkHeaders(String[] headers, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty(headers)) {
            String[] stringArray = headers;
            int n2 = headers.length;
            int n3 = 0;
            while (n3 < n2) {
                String header = stringArray[n3];
                int separator = header.indexOf(61);
                if (separator == -1) {
                    if (header.startsWith("!") ? request.getHeader(header.substring(1)) != null : request.getHeader(header) == null) {
                        return false;
                    }
                } else {
                    boolean negated = separator > 0 && header.charAt(separator - 1) == '!';
                    String key = !negated ? header.substring(0, separator) : header.substring(0, separator - 1);
                    String value = header.substring(separator + 1);
                    if (ServletAnnotationMappingUtils.isMediaTypeHeader(key)) {
                        List<MediaType> requestMediaTypes = MediaType.parseMediaTypes(request.getHeader(key));
                        List<MediaType> valueMediaTypes = MediaType.parseMediaTypes(value);
                        boolean found = false;
                        Iterator<MediaType> valIter = valueMediaTypes.iterator();
                        while (valIter.hasNext() && !found) {
                            MediaType valueMediaType = valIter.next();
                            Iterator<MediaType> reqIter = requestMediaTypes.iterator();
                            while (reqIter.hasNext() && !found) {
                                MediaType requestMediaType = reqIter.next();
                                if (!valueMediaType.includes(requestMediaType)) continue;
                                found = true;
                            }
                        }
                        if (!found) {
                            return negated;
                        }
                    } else if (!value.equals(request.getHeader(key))) {
                        return negated;
                    }
                }
                ++n3;
            }
        }
        return true;
    }

    private static boolean isMediaTypeHeader(String headerName) {
        return "Accept".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName);
    }
}

