/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.el.ELAttributeEvaluator;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.startup.BasicTilesInitializer;
import org.apache.tiles.startup.TilesInitializer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;
import org.springframework.web.servlet.view.tiles2.SpringTilesApplicationContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private static final boolean tilesElPresent = ClassUtils.isPresent("javax.servlet.jsp.JspApplicationContext", TilesConfigurer.class.getClassLoader()) && ClassUtils.isPresent("org.apache.tiles.evaluator.el.ELAttributeEvaluator", TilesConfigurer.class.getClassLoader());
    private static final boolean tiles22Present = ClassUtils.isPresent("org.apache.tiles.evaluator.AttributeEvaluatorFactory", TilesConfigurer.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TilesInitializer tilesInitializer;
    private boolean overrideLocaleResolver = false;
    private String[] definitions;
    private boolean checkRefresh = false;
    private boolean validateDefinitions = true;
    private Class<? extends DefinitionsFactory> definitionsFactoryClass;
    private Class<? extends PreparerFactory> preparerFactoryClass;
    private boolean useMutableTilesContainer = false;
    private final Map<String, String> tilesPropertyMap = new HashMap<String, String>();
    private ServletContext servletContext;

    public TilesConfigurer() {
        StringBuilder sb = new StringBuilder("org.apache.tiles.servlet.context.ServletTilesRequestContextFactory");
        TilesConfigurer.addClassNameIfPresent(sb, "org.apache.tiles.portlet.context.PortletTilesRequestContextFactory");
        TilesConfigurer.addClassNameIfPresent(sb, "org.apache.tiles.jsp.context.JspTilesRequestContextFactory");
        this.tilesPropertyMap.put("org.apache.tiles.context.ChainedTilesRequestContextFactory.FACTORY_CLASS_NAMES", sb.toString());
        this.tilesPropertyMap.put("org.apache.tiles.context.AbstractTilesApplicationContextFactory", SpringTilesApplicationContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.locale.LocaleResolver", SpringLocaleResolver.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", BasicPreparerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(false));
    }

    private static void addClassNameIfPresent(StringBuilder sb, String className) {
        if (ClassUtils.isPresent(className, TilesConfigurer.class.getClassLoader())) {
            sb.append(',').append(className);
        }
    }

    public void setTilesInitializer(TilesInitializer tilesInitializer) {
        this.tilesInitializer = tilesInitializer;
    }

    public void setCompleteAutoload(boolean completeAutoload) {
        if (completeAutoload) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("org.apache.tiles.extras.complete.CompleteAutoloadTilesInitializer");
                this.tilesInitializer = (TilesInitializer)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Tiles-Extras 2.2 not available", ex);
            }
        } else {
            this.tilesInitializer = null;
        }
        this.overrideLocaleResolver = completeAutoload;
    }

    public void setDefinitions(String[] definitions) {
        this.definitions = definitions;
        if (definitions != null) {
            String defs = StringUtils.arrayToCommaDelimitedString(definitions);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("TilesConfigurer: adding definitions [" + defs + "]");
            }
            this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG", defs);
        } else {
            this.tilesPropertyMap.remove("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG");
        }
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
        this.tilesPropertyMap.put("org.apache.tiles.definition.dao.LocaleUrlDefinitionDAO.CHECK_REFRESH", Boolean.toString(checkRefresh));
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.validateDefinitions = validateDefinitions;
        this.tilesPropertyMap.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.toString(validateDefinitions));
    }

    public void setDefinitionsFactoryClass(Class<? extends DefinitionsFactory> definitionsFactoryClass) {
        this.definitionsFactoryClass = definitionsFactoryClass;
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", definitionsFactoryClass.getName());
    }

    public void setPreparerFactoryClass(Class<? extends PreparerFactory> preparerFactoryClass) {
        this.preparerFactoryClass = preparerFactoryClass;
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", preparerFactoryClass.getName());
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.useMutableTilesContainer = useMutableTilesContainer;
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(useMutableTilesContainer));
    }

    public void setTilesProperties(Properties tilesProperties) {
        CollectionUtils.mergePropertiesIntoMap(tilesProperties, this.tilesPropertyMap);
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void afterPropertiesSet() throws TilesException {
        BasicTilesContainer container;
        boolean activateEl = false;
        if (tilesElPresent) {
            activateEl = new JspExpressionChecker().isExpressionFactoryAvailable();
            if (!this.tilesPropertyMap.containsKey("org.apache.tiles.evaluator.AttributeEvaluator")) {
                this.tilesPropertyMap.put("org.apache.tiles.evaluator.AttributeEvaluator", activateEl ? "org.apache.tiles.evaluator.el.ELAttributeEvaluator" : DirectAttributeEvaluator.class.getName());
            }
        }
        SpringTilesApplicationContextFactory factory = new SpringTilesApplicationContextFactory();
        factory.init(this.tilesPropertyMap);
        TilesApplicationContext preliminaryContext = factory.createApplicationContext(this.servletContext);
        if (this.tilesInitializer == null) {
            this.tilesInitializer = this.createTilesInitializer();
        }
        this.tilesInitializer.initialize(preliminaryContext);
        if (this.overrideLocaleResolver) {
            this.logger.debug("Registering Tiles 2.2 LocaleResolver for complete-autoload setup");
            try {
                container = (BasicTilesContainer)ServletUtil.getContainer((ServletContext)this.servletContext);
                DefinitionsFactory definitionsFactory = container.getDefinitionsFactory();
                Method setter = definitionsFactory.getClass().getMethod("setLocaleResolver", LocaleResolver.class);
                setter.invoke((Object)definitionsFactory, new Object[]{new SpringLocaleResolver()});
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot override LocaleResolver with SpringLocaleResolver", ex);
            }
        }
        if (activateEl && this.tilesInitializer instanceof SpringTilesInitializer) {
            container = (BasicTilesContainer)ServletUtil.getContainer((ServletContext)this.servletContext);
            new TilesElActivator().registerEvaluator(container);
        }
    }

    protected TilesInitializer createTilesInitializer() {
        return tiles22Present ? new SpringTilesInitializer() : new BasicTilesInitializer();
    }

    @Override
    public void destroy() throws TilesException {
        try {
            ReflectionUtils.invokeMethod(TilesInitializer.class.getMethod("destroy", new Class[0]), this.tilesInitializer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ServletUtil.setContainer((ServletContext)this.servletContext, null);
        }
    }

    private class JspExpressionChecker {
        private JspExpressionChecker() {
        }

        public boolean isExpressionFactoryAvailable() {
            try {
                JspFactory factory = JspFactory.getDefaultFactory();
                if (factory != null && factory.getJspApplicationContext(TilesConfigurer.this.servletContext).getExpressionFactory() != null) {
                    TilesConfigurer.this.logger.info("Found JSP 2.1 ExpressionFactory");
                    return true;
                }
            }
            catch (Throwable ex) {
                TilesConfigurer.this.logger.warn("Could not obtain JSP 2.1 ExpressionFactory", ex);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpringTilesContainerFactory
    extends BasicTilesContainerFactory {
        private SpringTilesContainerFactory() {
        }

        protected BasicTilesContainer instantiateContainer(TilesApplicationContext context) {
            return TilesConfigurer.this.useMutableTilesContainer ? new CachingTilesContainer() : new BasicTilesContainer();
        }

        protected void registerRequestContextFactory(String className, List<TilesRequestContextFactory> factories, TilesRequestContextFactory parent) {
            if (ClassUtils.isPresent(className, TilesConfigurer.class.getClassLoader())) {
                super.registerRequestContextFactory(className, factories, parent);
            }
        }

        protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            if (TilesConfigurer.this.definitions != null) {
                try {
                    LinkedList<URL> result = new LinkedList<URL>();
                    String[] stringArray = TilesConfigurer.this.definitions;
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String definition = stringArray[n3];
                        result.addAll(applicationContext.getResources(definition));
                        ++n3;
                    }
                    return result;
                }
                catch (IOException ex) {
                    throw new DefinitionsFactoryException("Cannot load definition URLs", (Exception)ex);
                }
            }
            return super.getSourceURLs(applicationContext, contextFactory);
        }

        protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
            BaseLocaleUrlDefinitionDAO dao = super.instantiateLocaleDefinitionDao(applicationContext, contextFactory, resolver);
            if (TilesConfigurer.this.checkRefresh && dao instanceof CachingLocaleUrlDefinitionDAO) {
                ((CachingLocaleUrlDefinitionDAO)dao).setCheckRefresh(TilesConfigurer.this.checkRefresh);
            }
            return dao;
        }

        protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            DigesterDefinitionsReader reader = new DigesterDefinitionsReader();
            if (!TilesConfigurer.this.validateDefinitions) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.FALSE.toString());
                reader.init(map);
            }
            return reader;
        }

        protected DefinitionsFactory createDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
            if (TilesConfigurer.this.definitionsFactoryClass != null) {
                BeanWrapper bw;
                DefinitionsFactory factory = (DefinitionsFactory)BeanUtils.instantiate(TilesConfigurer.this.definitionsFactoryClass);
                if (factory instanceof TilesApplicationContextAware) {
                    ((TilesApplicationContextAware)factory).setApplicationContext(applicationContext);
                }
                if ((bw = PropertyAccessorFactory.forBeanPropertyAccess(factory)).isWritableProperty("localeResolver")) {
                    bw.setPropertyValue("localeResolver", resolver);
                }
                if (bw.isWritableProperty("definitionDAO")) {
                    bw.setPropertyValue("definitionDAO", this.createLocaleDefinitionDao(applicationContext, contextFactory, resolver));
                }
                if (factory instanceof Refreshable) {
                    ((Refreshable)factory).refresh();
                }
                return factory;
            }
            return super.createDefinitionsFactory(applicationContext, contextFactory, resolver);
        }

        protected PreparerFactory createPreparerFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            if (TilesConfigurer.this.preparerFactoryClass != null) {
                return (PreparerFactory)BeanUtils.instantiate(TilesConfigurer.this.preparerFactoryClass);
            }
            return super.createPreparerFactory(applicationContext, contextFactory);
        }

        protected LocaleResolver createLocaleResolver(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
            return new SpringLocaleResolver();
        }
    }

    private class SpringTilesInitializer
    extends BasicTilesInitializer {
        private SpringTilesInitializer() {
        }

        protected AbstractTilesContainerFactory createContainerFactory(TilesApplicationContext context) {
            return new SpringTilesContainerFactory();
        }
    }

    private class TilesElActivator {
        private TilesElActivator() {
        }

        public void registerEvaluator(BasicTilesContainer container) {
            TilesConfigurer.this.logger.debug("Registering Tiles 2.2 AttributeEvaluatorFactory for JSP 2.1");
            try {
                ClassLoader cl = TilesElActivator.class.getClassLoader();
                Class<?> aef = cl.loadClass("org.apache.tiles.evaluator.AttributeEvaluatorFactory");
                Class<?> baef = cl.loadClass("org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory");
                Constructor<?> baefCtor = baef.getConstructor(AttributeEvaluator.class);
                ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
                evaluator.setApplicationContext(container.getApplicationContext());
                evaluator.init(new HashMap());
                Object baefValue = baefCtor.newInstance(evaluator);
                Method setter = container.getClass().getMethod("setAttributeEvaluatorFactory", aef);
                setter.invoke((Object)container, baefValue);
                Method getRequestContextFactory = BasicTilesContainer.class.getDeclaredMethod("getRequestContextFactory", new Class[0]);
                getRequestContextFactory.setAccessible(true);
                Method createRendererFactory = BasicTilesContainerFactory.class.getDeclaredMethod("createRendererFactory", TilesApplicationContext.class, TilesRequestContextFactory.class, TilesContainer.class, aef);
                createRendererFactory.setAccessible(true);
                BasicTilesContainerFactory tcf = new BasicTilesContainerFactory();
                RendererFactory rendererFactory = (RendererFactory)createRendererFactory.invoke((Object)tcf, container.getApplicationContext(), getRequestContextFactory.invoke((Object)container, new Object[0]), container, baefValue);
                container.setRendererFactory(rendererFactory);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot activate ELAttributeEvaluator", ex);
            }
        }
    }
}

