/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        int i2 = 0;
        while (i2 < input.length()) {
            char character = input.charAt(i2);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
            } else {
                escaped.append(character);
            }
            ++i2;
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        int i2 = 0;
        while (i2 < input.length()) {
            char character = input.charAt(i2);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
            } else {
                escaped.append(character);
            }
            ++i2;
        }
        return escaped.toString();
    }

    public static String htmlEscapeHex(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        int i2 = 0;
        while (i2 < input.length()) {
            char character = input.charAt(i2);
            if (characterEntityReferences.isMappedToReference(character)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
            } else {
                escaped.append(character);
            }
            ++i2;
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        if (input == null) {
            return null;
        }
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }
}

